DROP PROCEDURE [hips].[ClinicalDocumentVersionGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 12 Oct 2012
-- Description:   Gets one or more records from the ClinicalDocumentVersion table
-- Modified:
-- 06/12/2012 - sbiber - Made possible to check for duplicate source system document ID
-- 07/12/2012 - sbiber - Flag to get latest version only
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentVersionGet] 
(
	 @ClinicalDocumentId INT = NULL
	,@ClinicalDocumentVersionId INT = NULL
	,@SourceSystemDocumentId VARCHAR(128) = NULL
	,@LatestVersionOnly BIT
)
AS
BEGIN
IF @LatestVersionOnly = 0
SELECT  c.ClinicalDocumentVersionId,
		c.ClinicalDocumentId,
		c.SourceSystemDocumentId,
		c.UploadedDate,
		c.SupersededDate,
		c.Package,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified
FROM  hips.ClinicalDocumentVersion c
WHERE (c.ClinicalDocumentId = @ClinicalDocumentId OR @ClinicalDocumentId IS NULL)
AND (c.ClinicalDocumentVersionId = @ClinicalDocumentVersionId OR @ClinicalDocumentVersionId IS NULL)
AND (c.SourceSystemDocumentId = @SourceSystemDocumentId OR @SourceSystemDocumentId IS NULL)
ELSE
SELECT  TOP 1
		c.ClinicalDocumentVersionId,
		c.ClinicalDocumentId,
		c.SourceSystemDocumentId,
		c.UploadedDate,
		c.SupersededDate,
		c.Package,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified
FROM  hips.ClinicalDocumentVersion c
WHERE (c.ClinicalDocumentId = @ClinicalDocumentId OR @ClinicalDocumentId IS NULL)
AND (c.ClinicalDocumentVersionId = @ClinicalDocumentVersionId OR @ClinicalDocumentVersionId IS NULL)
AND (c.SourceSystemDocumentId = @SourceSystemDocumentId OR @SourceSystemDocumentId IS NULL)
ORDER BY c.ClinicalDocumentVersionId DESC

END
GO

